-- Create ai_responses table
CREATE TABLE IF NOT EXISTS `ai_responses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `query` text NOT NULL,
  `summary` text,
  `raw_response` longtext,
  `markdown_response` longtext,
  `insights` json DEFAULT NULL,
  `data_points` json DEFAULT NULL,
  `ai_provider` varchar(50) DEFAULT NULL,
  `response_time_ms` int(11) DEFAULT NULL,
  `status` enum('success','error','pending') DEFAULT 'success',
  `error_message` text,
  `createdAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updatedAt` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ai_responses_user_id` (`user_id`),
  KEY `ai_responses_company_id` (`company_id`),
  CONSTRAINT `ai_responses_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ai_responses_ibfk_2` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
