const sequelize = require('../config/database');
const Company = require('./Company');
const User = require('./User');
const RkapProgram = require('./RkapProgram');
const ApprovalRequest = require('./ApprovalRequest');
const ActivityLog = require('./ActivityLog');
const SessionLog = require('./SessionLog');
const ApiLog = require('./ApiLog');
const AiResponse = require('./AiResponse');

// Define associations
User.belongsTo(Company, { foreignKey: 'company_id', as: 'company' });
Company.hasMany(User, { foreignKey: 'company_id', as: 'users' });

RkapProgram.belongsTo(User, { foreignKey: 'user_id', as: 'user' });
RkapProgram.belongsTo(Company, { foreignKey: 'company_id', as: 'company' });
User.hasMany(RkapProgram, { foreignKey: 'user_id', as: 'rkapPrograms' });
Company.hasMany(RkapProgram, { foreignKey: 'company_id', as: 'rkapPrograms' });

ApprovalRequest.belongsTo(RkapProgram, { foreignKey: 'rkap_program_id', as: 'rkapProgram' });
ApprovalRequest.belongsTo(User, { foreignKey: 'requested_by_user_id', as: 'requested_by' });
RkapProgram.hasMany(ApprovalRequest, { foreignKey: 'rkap_program_id', as: 'approvalRequests' });

ActivityLog.belongsTo(User, { foreignKey: 'user_id', as: 'user' });
ActivityLog.belongsTo(Company, { foreignKey: 'company_id', as: 'company' });
User.hasMany(ActivityLog, { foreignKey: 'user_id', as: 'activityLogs' });
Company.hasMany(ActivityLog, { foreignKey: 'company_id', as: 'activityLogs' });

SessionLog.belongsTo(User, { foreignKey: 'user_id', as: 'user' });
SessionLog.belongsTo(Company, { foreignKey: 'company_id', as: 'company' });
User.hasMany(SessionLog, { foreignKey: 'user_id', as: 'sessionLogs' });
Company.hasMany(SessionLog, { foreignKey: 'company_id', as: 'sessionLogs' });

ApiLog.belongsTo(User, { foreignKey: 'user_id', as: 'user' });
ApiLog.belongsTo(Company, { foreignKey: 'company_id', as: 'company' });
User.hasMany(ApiLog, { foreignKey: 'user_id', as: 'apiLogs' });
Company.hasMany(ApiLog, { foreignKey: 'company_id', as: 'apiLogs' });

// Set up AiResponse associations
AiResponse.belongsTo(User, { foreignKey: 'user_id', as: 'user' });
AiResponse.belongsTo(Company, { foreignKey: 'company_id', as: 'company' });
User.hasMany(AiResponse, { foreignKey: 'user_id', as: 'aiResponses' });
Company.hasMany(AiResponse, { foreignKey: 'company_id', as: 'aiResponses' });

// Sync database
const syncDatabase = async () => {
  try {
    await sequelize.authenticate();
    console.log('Database connection established successfully.');
    
    // Sync all models - use force: false to avoid index conflicts
    await sequelize.sync({ alter: false });
    console.log('Database synchronized successfully.');
  } catch (error) {
    console.error('Unable to connect to the database:', error);
  }
};

module.exports = {
  sequelize,
  Company,
  User,
  RkapProgram,
  ApprovalRequest,
  ActivityLog,
  SessionLog,
  ApiLog,
  AiResponse,
  syncDatabase
};
