const { DataTypes } = require('sequelize');
const sequelize = require('../config/database');

const RkapProgram = sequelize.define('RkapProgram', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  user_id: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: {
      model: 'users',
      key: 'id'
    }
  },
  company_id: {
    type: DataTypes.INTEGER,
    allowNull: false,
    references: {
      model: 'companies',
      key: 'id'
    }
  },
  category: {
    type: DataTypes.STRING(255),
    allowNull: true
  },
  sub_category: {
    type: DataTypes.STRING(255),
    allowNull: true
  },
  program_name: {
    type: DataTypes.TEXT,
    allowNull: false
  },
  cost_center: {
    type: DataTypes.STRING(255),
    allowNull: true
  },
  beban: {
    type: DataTypes.STRING(255),
    allowNull: true
  },
  type: {
    type: DataTypes.ENUM('CAPEX', 'OPEX'),
    allowNull: false
  },
  proposed_amount: {
    type: DataTypes.DECIMAL(15, 2),
    allowNull: false
  },
  approved_amount: {
    type: DataTypes.DECIMAL(15, 2),
    allowNull: true
  },
  realized_amount: {
    type: DataTypes.DECIMAL(15, 2),
    allowNull: true
  },
  status: {
    type: DataTypes.ENUM('Pengajuan', 'Disetujui', 'Selesai', 'Ditolak'),
    allowNull: false,
    defaultValue: 'Pengajuan'
  },
  notes: {
    type: DataTypes.TEXT,
    allowNull: true
  },
  year: {
    type: DataTypes.INTEGER,
    allowNull: false
  }
}, {
  tableName: 'rkap_programs',
  timestamps: true,
  createdAt: 'created_at',
  updatedAt: 'updated_at',
  indexes: [
    {
      fields: ['year', 'status']
    },
    {
      fields: ['company_id']
    }
  ]
});

module.exports = RkapProgram;
