const { DataTypes } = require('sequelize');
const sequelize = require('../config/database');

const ApiLog = sequelize.define('ApiLog', {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true
  },
  user_id: {
    type: DataTypes.INTEGER,
    allowNull: true,
    references: {
      model: 'users',
      key: 'id'
    }
  },
  endpoint: {
    type: DataTypes.STRING(255),
    allowNull: false
  },
  method: {
    type: DataTypes.STRING(10),
    allowNull: false
  },
  status_code: {
    type: DataTypes.INTEGER,
    allowNull: false
  },
  response_time_ms: {
    type: DataTypes.INTEGER,
    allowNull: true
  },
  request_data: {
    type: DataTypes.JSON,
    allowNull: true
  },
  response_data: {
    type: DataTypes.JSON,
    allowNull: true
  },
  ip_address: {
    type: DataTypes.STRING(45),
    allowNull: true
  },
  user_agent: {
    type: DataTypes.TEXT,
    allowNull: true
  }
}, {
  tableName: 'api_logs',
  timestamps: true,
  createdAt: 'timestamp',
  updatedAt: false
});

module.exports = ApiLog;
