const { DataTypes } = require('sequelize');
const sequelize = require('../config/database');

const AiResponse = sequelize.define('AiResponse', {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: 'users',
        key: 'id'
      }
    },
    company_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: 'companies',
        key: 'id'
      }
    },
    query: {
      type: DataTypes.TEXT,
      allowNull: false
    },
    summary: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    raw_response: {
      type: DataTypes.TEXT('long'),
      allowNull: true
    },
    markdown_response: {
      type: DataTypes.TEXT('long'),
      allowNull: true
    },
    insights: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    data_points: {
      type: DataTypes.TEXT,
      allowNull: true
    },
    ai_provider: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    response_time_ms: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    status: {
      type: DataTypes.ENUM('success', 'error', 'pending'),
      defaultValue: 'success'
    },
    error_message: {
      type: DataTypes.TEXT,
      allowNull: true
    }
  }, {
    tableName: 'ai_responses',
    timestamps: true,
    indexes: [
      {
        fields: ['user_id']
      },
      {
        fields: ['company_id']
      }
    ]
  });

  // Associations are set in models/index.js

module.exports = AiResponse;
